{*
 * Projecte Fressa a LINKAT
 * GLOBUS3
 *
 * @author Jordi Lagares Roset "jlagares@xtec.cat - www.lagares.org"
 * amb el suport del Departament d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 *}

unit UnitFormPlasma;

{************************************************}
INTERFACE
{************************************************}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ExtCtrls, MMSystem;

type
  TFormPlasma = class(TForm)
    Panel: TPanel;
    SpeedButtonEngegarParar: TSpeedButton;
    SpeedButtonCaixaEines: TSpeedButton;
    SpeedButtonCopiarALaCarpeta: TSpeedButton;
    procedure SpeedButtonEngegarPararClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SpeedButtonCaixaEinesClick(Sender: TObject);
    procedure SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    procedure WMWIMDATA(var Msg: TMessage); message MM_WIM_DATA;
  public
    { Public declarations }
    HiHaPrograma:boolean;
  end;

var
  FormPlasma: TFormPlasma;

{************************************************}
IMPLEMENTATION
{************************************************}

uses ShellApi, UnitEntradaSo, UnitCanviDeparametres, UnitTools, TLHelp32;

{$R *.DFM}

function CierraExe(FicheroExe:string):boolean;

  function SacaExe(MangoW:HWND):string;
  {Obtiene el EXE de una tarea}
  {get EXE of a task}
  var
    Datos    :TProcessEntry32;
    hID       :DWord;
    Snap    : Integer;
  begin
    GetWindowThreadProcessId(MangoW,@hID);
    Snap:=CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS,0);
    try
      Datos.dwSize:=SizeOf(Datos);
      if(Process32First(Snap,Datos))then
      begin
        repeat
          if Datos.th32ProcessID=hID then
          begin
            Result:=StrPas(Datos.szExeFile);
            Break;
          end;
        until not(Process32Next(Snap,Datos));
      end;
    finally
      Windows.CloseHandle(Snap);
    end;
  end;
 function ObtieneVentanas(Mango: HWND;ACerrar: Pointer): Boolean; stdcall;
 begin
   Result := True;
   {Mango es el handle de la tarea encontrada}
   {Si es el .EXE buscado, lo cierra}
   if SacaExe(Mango)=UpperCase( String(ACerrar^) )then
   begin
     SendMessage(Mango,WM_Close,0,0);
     String(Acerrar^):='CERRADO';
   end;
 end;
begin
  EnumWindows( @ObtieneVentanas, Integer(@FicheroExe) );
  Result:=(FicheroExe='CERRADO');
end;

procedure TFormPlasma.FormCreate(Sender: TObject);
begin
  HiHaPrograma:=false;
end;

procedure TFormPlasma.FormClose(Sender: TObject;var Action: TCloseAction);
var
  Mango:HWnd;
begin
  if not (SpeedButtonEngegarParar.Caption='E') then begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
    SpeedButtonEngegarParar.Down:=false;
  end;
  Mango:=FindWindow(nil,'Plasma programa extern Globus 3');
  if mango<>0 then SendMessage(Mango,WM_CLOSE,0,0);
end;

procedure TFormPlasma.SpeedButtonEngegarPararClick(Sender: TObject);
begin
  if SpeedButtonEngegarParar.Caption='E' then begin
    SpeedButtonEngegarParar.Caption:='P';
    RePaint;
    IniciarDadesUnitEntradaSo(512);
    EngegarProcesEntradaSo(Handle);
  end else begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
  end;
end;

procedure TFormPlasma.WMWIMDATA(var Msg: TMessage);
var
  i,Max:integer;
  Mango:HWnd;
begin
  Max:=0;
  For i:=1 to BytesBuffer do if so[NumeroBufer,i]-127>Max then Max:=so[NumeroBufer,i]-127;
  if Max>ValorMinim then begin
    if not HiHaPrograma then begin
      Mango:=FindWindow(nil,'Plasma programa extern Globus 3');
      //if mango=0 then ShellExecute(0, Nil, 'plasma.exe', Nil, Nil, SW_NORMAL);
      if mango=0 then ShellExecute(0, Nil, 'plasma.exe', 'globus3P987654321', Nil, SW_NORMAL);
      HiHaPrograma:=true;
    end;
  end else begin
    //if HiHaPrograma then begin
      //Keybd_Event(vk_Escape,0,0,0);
      //Keybd_Event(vk_Escape,0,KEYEVENTF_KEYUP,0);
      //CierraExe('plasma.exe');
      Mango:=FindWindow(nil,'Plasma programa extern Globus 3');
      if mango<>0 then SendMessage(Mango,WM_CLOSE,0,0);
      HiHaPrograma:=false;
    //end;
  end;
  EntradaSo;
end;

procedure TFormPlasma.SpeedButtonCaixaEinesClick(Sender: TObject);
begin
  FormCanviDeParametres.ShowModal;
end;


procedure TFormPlasma.SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
var
  Rect:TRect;
begin
  Rect.Left:=0;
  Rect.Top:=Panel.Height;
  Rect.Right:=ClientRect.Right;
  Rect.Bottom:=ClientRect.Bottom;
  CopiarPartDeLaFinestraALaCarpeta(Handle,Rect);
end;

end.
